/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.WaitForUserDialog;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoissonNTF_
implements PlugInFilter {
    String PoissonNTFversion = "0.3.1";
    ImagePlus[] imp = null;
    ImageStack[] X = null;
    ImagePlus img = null;
    ImageStack A = null;
    int ndyes = 3;
    int nemn;
    int nexc;
    int w;
    int h;
    int wh;
    int tz_dim;
    int totalchannels;
    int[][] dim;
    int[] nchannels;
    int[][] channeltoemission;
    int[] lowerexc = null;
    int[] upperexc = null;
    int CANCELLED = -1;
    int NOROISELECTED = -2;
    int GOODINPUT = 1;
    int BADVALUE = -3;
    int[] bgMask;
    double[][][] Xsub;
    double[][] Asub;
    double[][][] QASsub;
    double[][] S;
    double[][] Q;
    float[][] initialS;
    double[][] pinvS;
    Vector<Vector<Double>> ChannelsL = null;
    Vector<Vector<Double>> ChannelsR = null;
    Vector<String> excitation_wavelength = null;
    Vector<Double> emission_wavelength = null;
    Vector<Double> channel_width = null;
    int[] channel_order;
    int[] inverse_channel_order;
    double[][] Segbiasterm;
    double[][] bg;
    double[][] bg_sigma;
    double[][][] Sexc;
    double[] power;
    float signal_nothing = 1.0f;
    double conc_nothing = 1.0;
    double spec_nothing = 0.001;
    double E = 1.0;
    double segbias = 0.0;
    int noPix;
    boolean isHyperstack;
    double bg_threshold = 20.0;
    double no_std = 2.0;
    double saturation_threshold = 4000.0;
    boolean[] spectra_fixed;
    boolean[] imageselected;
    int maxit = 100;
    int subsamples = 3;
    int nmf_preiterations = 50;
    int no_preiterations = 20;
    int no_postiterations = 5;
    boolean cancelled = false;
    boolean interrupted = false;
    String[] spec_choice;
    String bg_choice;
    PlotWindow plotEmission = null;
    PlotWindow plotExcitation = null;
    String datatype;
    String[] datatype_choices;
    String config_file;

    public int setup(String string, ImagePlus imagePlus) {
        this.datatype_choices = new String[3];
        this.datatype_choices[0] = "Regular stacks";
        this.datatype_choices[1] = "Leica SP2";
        this.datatype_choices[2] = "Zeiss LSM";
        this.datatype = this.datatype_choices[1];
        if (this.imp == null) {
            GenericDialog genericDialog = new GenericDialog("Select Data type");
            genericDialog.addChoice("Type:", this.datatype_choices, this.datatype);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return 4096;
            }
            this.datatype = genericDialog.getNextChoice();
            if (this.datatype.equals(this.datatype_choices[1]) && this.openLeicaSP2() == this.CANCELLED) {
                return 4096;
            }
        }
        if (this.imp != null) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.nexc; ++n2) {
                this.dim[n2] = this.imp[n2].getDimensions();
            }
            n2 = 1;
            for (n = 2; n < this.dim[0].length; ++n) {
                n2 *= this.dim[0][n];
            }
            if (n2 == 1) {
                IJ.error((String)"Stack required!");
                return 4096;
            }
            this.isHyperstack = this.imp[0].isHyperStack();
            for (n = 0; n < this.nexc; ++n) {
                if (this.imp[n].getBytesPerPixel() < 32) {
                    new StackConverter(this.imp[n]).convertToGray32();
                }
                this.X[n] = this.imp[n].getStack();
            }
        } else {
            IJ.error((String)"Stack required!");
            return 4096;
        }
        this.w = this.dim[0][0];
        this.h = this.dim[0][1];
        this.wh = this.w * this.h;
        this.tz_dim = this.isHyperstack ? this.dim[0][3] * this.dim[0][4] : 1;
        this.bgMask = new int[this.wh * this.tz_dim];
        if (string.equals("about")) {
            this.showAbout();
            return 4096;
        }
        return 525;
    }

    public void run(ImageProcessor imageProcessor) {
        int n;
        if (IJ.versionLessThan((String)"1.39t")) {
            IJ.error((String)"PoissonNTF requires ImageJ version 1.39t or greater!");
            return;
        }
        if (this.parameterDialog() < 0) {
            return;
        }
        int[] nArray = new int[this.subsamples];
        double d = 0.0;
        this.segbias *= (double)this.nexc * 0.5 * Math.log(Math.max(this.bg_threshold, 100.0));
        for (n = this.subsamples - 1; n >= 0; --n) {
            d += Math.pow(2.0, n);
        }
        for (n = this.subsamples - 1; n >= 0; --n) {
            nArray[n] = (int)((double)this.maxit * Math.pow(2.0, n) / d);
        }
        double d2 = 0.0;
        for (int i = this.subsamples - 1; i >= 0; --i) {
            d2 += Math.pow(0.1, i) * (double)nArray[i];
        }
        double d3 = 0.0;
        PoissonNTFprogress poissonNTFprogress = new PoissonNTFprogress(this);
        this.subsample(Math.pow(0.1, this.subsamples - 1));
        block3: for (int i = this.subsamples - 1; i >= 0; --i) {
            this.subsample(Math.pow(0.1, i));
            if (i == this.subsamples - 1) {
                this.initialization_QAS();
            } else {
                this.solveforA();
            }
            for (int j = 0; j < nArray[i]; ++j) {
                IJ.showProgress((double)(d3 / d2));
                this.normalizeNTF();
                this.updateS_NTF();
                this.updateA_NTF();
                this.updateQ_NTF();
                d3 += Math.pow(0.1, i);
                if (this.cancelled) {
                    return;
                }
                if (this.interrupted) {
                    i = -1;
                    continue block3;
                }
                this.plotEmissionSpectra();
                this.plotExcitationSpectra();
            }
        }
        if (!this.cancelled && !this.interrupted) {
            poissonNTFprogress.closeWindow();
        }
        IJ.showProgress((double)1.0);
        this.showConcentrations();
        this.plotExcitationSpectra();
        this.plotEmissionSpectra();
        PoissonNTFresultsPanel poissonNTFresultsPanel = new PoissonNTFresultsPanel(this);
    }

    private void initialization_QAS() {
        this.initA();
        for (int i = 0; i < this.nexc; ++i) {
            int n;
            for (n = 0; n < this.no_preiterations; ++n) {
                this.normalizeNMF(i);
                this.updateA_NMF(i);
            }
            for (n = 0; n < this.nmf_preiterations; ++n) {
                this.normalizeNMF(i);
                this.updateS_NMF(i);
                this.updateA_NMF(i);
            }
        }
        this.splice_spectra();
    }

    private void initA() {
        for (int i = 0; i < this.noPix; ++i) {
            for (int j = 0; j < this.ndyes; ++j) {
                this.Asub[i][j] = (float)(Math.random() / 2.0 + 0.5);
            }
        }
    }

    private void subsample(double d) {
        int n;
        int n2;
        int n3;
        this.noPix = 0;
        int n4 = 0;
        for (n3 = 0; n3 < this.tz_dim; ++n3) {
            for (n2 = n = n3 * this.wh; n2 < n + this.wh; ++n2) {
                if (this.bgMask[n2] > 0 && Math.random() < d) {
                    this.bgMask[n2] = 2 * this.totalchannels;
                }
                if (this.bgMask[n2] != 2 * this.totalchannels) continue;
                ++this.noPix;
            }
        }
        this.Xsub = new double[this.nexc][this.noPix][this.nemn];
        this.Asub = new double[this.noPix][this.ndyes];
        this.Segbiasterm = new double[this.noPix][this.ndyes];
        this.QASsub = new double[this.nexc][this.noPix][this.nemn];
        for (n3 = 0; n3 < this.tz_dim; ++n3) {
            n = n3 * this.wh;
            for (n2 = 0; n2 < this.wh; ++n2) {
                if (this.bgMask[n + n2] != 2 * this.totalchannels) continue;
                for (int i = 0; i < this.nexc; ++i) {
                    int n5 = n3 * this.nchannels[i];
                    for (int j = 0; j < this.nchannels[i]; ++j) {
                        this.Xsub[i][n4][this.channeltoemission[i][j]] = (double)((float[])this.X[i].getPixels(n5 + j + 1))[n2] - this.bg[i][j];
                        if (!(this.Xsub[i][n4][this.channeltoemission[i][j]] < (double)this.signal_nothing)) continue;
                        this.Xsub[i][n4][this.channeltoemission[i][j]] = this.signal_nothing;
                    }
                }
                ++n4;
            }
        }
    }

    private void calc_QASsub() {
        for (int i = 0; i < this.nexc; ++i) {
            for (int j = 0; j < this.noPix; ++j) {
                for (int k = 0; k < this.nemn; ++k) {
                    this.QASsub[i][j][k] = 0.0;
                    for (int i2 = 0; i2 < this.ndyes; ++i2) {
                        double[] dArray = this.QASsub[i][j];
                        int n = k;
                        dArray[n] = dArray[n] + this.Q[i][i2] * this.Asub[j][i2] * this.S[k][i2];
                    }
                }
            }
        }
    }

    private void updateS_NMF(int n) {
        int n2;
        int n3;
        int n4;
        float[] fArray = new float[this.ndyes];
        for (n4 = 0; n4 < this.noPix; ++n4) {
            for (n3 = 0; n3 < this.nchannels[n]; ++n3) {
                this.QASsub[n][n4][n3] = 0.0;
                for (n2 = 0; n2 < this.ndyes; ++n2) {
                    double[] dArray = this.QASsub[n][n4];
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + this.Q[n][n2] * this.Asub[n4][n2] * this.Sexc[n][n3][n2];
                }
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            fArray[n2] = 0.0f;
            for (n4 = 0; n4 < this.noPix; ++n4) {
                int n6 = n2;
                fArray[n6] = (float)((double)fArray[n6] + this.Q[n][n2] * this.Asub[n4][n2]);
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            if (this.spectra_fixed[n2]) continue;
            for (n3 = 0; n3 < this.nchannels[n]; ++n3) {
                float f = 0.0f;
                for (n4 = 0; n4 < this.noPix; ++n4) {
                    f = (float)((double)f + this.Asub[n4][n2] * this.Xsub[n][n4][this.channeltoemission[n][n3]] / this.QASsub[n][n4][n3]);
                }
                double[] dArray = this.Sexc[n][n3];
                int n7 = n2;
                dArray[n7] = dArray[n7] * (double)(f / fArray[n2]);
            }
        }
    }

    private void updateA_NMF(int n) {
        double d;
        int n2;
        int n3;
        int n4;
        float[] fArray = new float[this.ndyes];
        for (n4 = 0; n4 < this.noPix; ++n4) {
            for (n3 = 0; n3 < this.nchannels[n]; ++n3) {
                this.QASsub[n][n4][n3] = 0.0;
                for (n2 = 0; n2 < this.ndyes; ++n2) {
                    double[] dArray = this.QASsub[n][n4];
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + this.Q[n][n2] * this.Asub[n4][n2] * this.Sexc[n][n3][n2];
                }
            }
        }
        if (this.segbias > 0.0) {
            for (n4 = 0; n4 < this.noPix; ++n4) {
                double d2 = 0.0;
                double d3 = 0.0;
                for (n2 = 0; n2 < this.ndyes; ++n2) {
                    d = this.Asub[n4][n2];
                    d2 += d;
                    d3 += d * d;
                }
                d2 /= d3;
                d3 = Math.sqrt(d3);
                d2 /= d3;
                for (n2 = 0; n2 < this.ndyes; ++n2) {
                    this.Segbiasterm[n4][n2] = this.segbias * (d2 * this.Asub[n4][n2] - 1.0 / d3);
                }
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            fArray[n2] = 0.0f;
            for (n3 = 0; n3 < this.nchannels[n]; ++n3) {
                int n6 = n2;
                fArray[n6] = (float)((double)fArray[n6] + this.Q[n][n2] * this.Sexc[n][n3][n2]);
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n4 = 0; n4 < this.noPix; ++n4) {
                d = 0.0;
                for (n3 = 0; n3 < this.nchannels[n]; ++n3) {
                    d += this.Xsub[n][n4][this.channeltoemission[n][n3]] / this.QASsub[n][n4][n3] * this.Sexc[n][n3][n2];
                }
                double[] dArray = this.Asub[n4];
                int n7 = n2;
                dArray[n7] = dArray[n7] * ((d + this.Segbiasterm[n4][n2]) / (double)fArray[n2]);
                if (!(this.Asub[n4][n2] < this.conc_nothing)) continue;
                this.Asub[n4][n2] = this.conc_nothing;
            }
        }
    }

    private void updateS_NTF() {
        int n;
        int n2;
        int n3;
        int n4;
        float[][] fArray = new float[this.nemn][this.ndyes];
        this.calc_QASsub();
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            for (n3 = 0; n3 < this.nemn; ++n3) {
                fArray[n3][n4] = 0.0f;
                for (n2 = this.lowerexc[n3]; n2 < this.upperexc[n3]; ++n2) {
                    for (n = 0; n < this.noPix; ++n) {
                        float[] fArray2 = fArray[n3];
                        int n5 = n4;
                        fArray2[n5] = (float)((double)fArray2[n5] + this.Q[n2][n4] * this.Asub[n][n4]);
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            if (this.spectra_fixed[n4]) continue;
            for (n3 = 0; n3 < this.nemn; ++n3) {
                float f = 0.0f;
                for (n2 = this.lowerexc[n3]; n2 < this.upperexc[n3]; ++n2) {
                    for (n = 0; n < this.noPix; ++n) {
                        f = (float)((double)f + this.Q[n2][n4] * this.Asub[n][n4] * this.Xsub[n2][n][n3] / this.QASsub[n2][n][n3]);
                    }
                }
                double[] dArray = this.S[n3];
                int n6 = n4;
                dArray[n6] = dArray[n6] * (double)(f / fArray[n3][n4]);
                if (!(this.S[n3][n4] < this.spec_nothing)) continue;
                this.S[n3][n4] = this.spec_nothing;
            }
        }
    }

    private void updateQ_NTF() {
        int n;
        int n2;
        int n3;
        int n4;
        float[][] fArray = new float[this.nexc][this.ndyes];
        this.calc_QASsub();
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            for (n3 = 0; n3 < this.nexc; ++n3) {
                fArray[n3][n4] = 0.0f;
                for (n2 = 0; n2 < this.nchannels[n3]; ++n2) {
                    for (n = 0; n < this.noPix; ++n) {
                        float[] fArray2 = fArray[n3];
                        int n5 = n4;
                        fArray2[n5] = (float)((double)fArray2[n5] + this.S[this.channeltoemission[n3][n2]][n4] * this.Asub[n][n4]);
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            for (n3 = 0; n3 < this.nexc; ++n3) {
                float f = 0.0f;
                for (n2 = 0; n2 < this.nchannels[n3]; ++n2) {
                    for (n = 0; n < this.noPix; ++n) {
                        f = (float)((double)f + this.S[this.channeltoemission[n3][n2]][n4] * this.Asub[n][n4] * this.Xsub[n3][n][this.channeltoemission[n3][n2]] / this.QASsub[n3][n][this.channeltoemission[n3][n2]]);
                    }
                }
                double[] dArray = this.Q[n3];
                int n6 = n4;
                dArray[n6] = dArray[n6] * (double)(f / fArray[n3][n4]);
            }
        }
    }

    private void updateA_NTF() {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        float[] fArray = new float[this.ndyes];
        this.calc_QASsub();
        if (this.segbias > 0.0) {
            for (n4 = 0; n4 < this.noPix; ++n4) {
                double d2 = 0.0;
                double d3 = 0.0;
                for (n3 = 0; n3 < this.ndyes; ++n3) {
                    d = this.Asub[n4][n3];
                    d2 += d;
                    d3 += d * d;
                }
                d2 /= d3;
                d3 = Math.sqrt(d3);
                d2 /= d3;
                for (n3 = 0; n3 < this.ndyes; ++n3) {
                    this.Segbiasterm[n4][n3] = this.segbias * (d2 * this.Asub[n4][n3] - 1.0 / d3);
                }
            }
        }
        for (n3 = 0; n3 < this.ndyes; ++n3) {
            fArray[n3] = 0.0f;
            for (n2 = 0; n2 < this.nexc; ++n2) {
                for (n = 0; n < this.nchannels[n2]; ++n) {
                    int n5 = n3;
                    fArray[n5] = (float)((double)fArray[n5] + this.Q[n2][n3] * this.S[this.channeltoemission[n2][n]][n3]);
                }
            }
        }
        for (n3 = 0; n3 < this.ndyes; ++n3) {
            for (n4 = 0; n4 < this.noPix; ++n4) {
                d = 0.0;
                for (n2 = 0; n2 < this.nexc; ++n2) {
                    for (n = 0; n < this.nchannels[n2]; ++n) {
                        d += this.Xsub[n2][n4][this.channeltoemission[n2][n]] / this.QASsub[n2][n4][this.channeltoemission[n2][n]] * this.S[this.channeltoemission[n2][n]][n3] * this.Q[n2][n3];
                    }
                }
                double[] dArray = this.Asub[n4];
                int n6 = n3;
                dArray[n6] = dArray[n6] * ((d + this.Segbiasterm[n4][n3]) / (double)fArray[n3]);
                if (!(this.Asub[n4][n3] < this.conc_nothing)) continue;
                this.Asub[n4][n3] = this.conc_nothing;
            }
        }
    }

    private void normalizeNMF(int n) {
        for (int i = 0; i < this.ndyes; ++i) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < this.noPix; ++n2) {
                d += this.Asub[n2][i];
            }
            d *= 0.01 / (double)this.noPix;
            for (n2 = 0; n2 < this.noPix; ++n2) {
                double[] dArray = this.Asub[n2];
                int n3 = i;
                dArray[n3] = dArray[n3] / d;
            }
            for (int j = 0; j < this.nchannels[n]; ++j) {
                double[] dArray = this.Sexc[n][j];
                int n4 = i;
                dArray[n4] = dArray[n4] * d;
            }
        }
    }

    private void normalizeNTF() {
        int n;
        for (n = 0; n < this.ndyes; ++n) {
            int n2;
            this.power[n] = 0.0;
            for (n2 = 0; n2 < this.nemn; ++n2) {
                int n3 = n;
                this.power[n3] = this.power[n3] + Math.pow(this.S[n2][n], this.E);
            }
            this.power[n] = (float)Math.pow(this.power[n], 1.0 / this.E);
            for (n2 = 0; n2 < this.nemn; ++n2) {
                double[] dArray = this.S[n2];
                int n4 = n;
                dArray[n4] = dArray[n4] / this.power[n];
            }
        }
        for (n = 0; n < this.ndyes; ++n) {
            int n5;
            double d = 0.0;
            for (n5 = 0; n5 < this.nexc; ++n5) {
                d += Math.pow(this.Q[n5][n], this.E);
            }
            int n6 = n;
            this.power[n6] = this.power[n6] * (double)((float)Math.pow(d, 1.0 / this.E));
            for (n5 = 0; n5 < this.nexc; ++n5) {
                double[] dArray = this.Q[n5];
                int n7 = n;
                dArray[n7] = dArray[n7] / d;
            }
        }
        for (n = 0; n < this.ndyes; ++n) {
            for (int i = 0; i < this.noPix; ++i) {
                double[] dArray = this.Asub[i];
                int n8 = n;
                dArray[n8] = dArray[n8] * this.power[n];
            }
        }
    }

    private void normalizeNTF_maxConc() {
        int n;
        for (n = 0; n < this.ndyes; ++n) {
            int n2;
            this.power[n] = 0.0;
            for (n2 = 0; n2 < this.nemn; ++n2) {
                int n3 = n;
                this.power[n3] = this.power[n3] + Math.pow(this.S[n2][n], this.E);
            }
            this.power[n] = (float)Math.pow(this.power[n], 1.0 / this.E);
            for (n2 = 0; n2 < this.nemn; ++n2) {
                double[] dArray = this.S[n2];
                int n4 = n;
                dArray[n4] = dArray[n4] / this.power[n];
            }
        }
        for (n = 0; n < this.ndyes; ++n) {
            int n5;
            double d = 0.0;
            for (n5 = 0; n5 < this.noPix; ++n5) {
                if (!(this.Asub[n5][n] > d)) continue;
                d = this.Asub[n5][n];
            }
            int n6 = n;
            this.power[n6] = this.power[n6] * d;
            for (n5 = 0; n5 < this.noPix; ++n5) {
                double[] dArray = this.Asub[n5];
                int n7 = n;
                dArray[n7] = dArray[n7] / d;
            }
        }
        for (n = 0; n < this.ndyes; ++n) {
            for (int i = 0; i < this.nexc; ++i) {
                double[] dArray = this.Q[i];
                int n8 = n;
                dArray[n8] = dArray[n8] * this.power[n];
            }
        }
    }

    private void solveforA() {
        this.calc_pinv();
        for (int i = 0; i < this.noPix; ++i) {
            for (int j = 0; j < this.ndyes; ++j) {
                this.Asub[i][j] = 0.0;
                int n = 0;
                for (int k = 0; k < this.nexc; ++k) {
                    for (int i2 = 0; i2 < this.nchannels[k]; ++i2) {
                        double[] dArray = this.Asub[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + this.pinvS[j][n] * this.Xsub[k][i][this.channeltoemission[k][i2]];
                        ++n;
                    }
                }
            }
        }
    }

    private int parameterDialog() {
        GenericDialog genericDialog = new GenericDialog("Poisson NTF");
        genericDialog.addNumericField("Number of Sources", (double)this.ndyes, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return this.CANCELLED;
        }
        this.ndyes = (int)genericDialog.getNextNumber();
        if (this.ndyes < 2 || this.ndyes > 10) {
            IJ.error((String)"Bad number of Sources!");
            return -1;
        }
        this.allocate_ndyes_dependent();
        this.getPrefs();
        GenericDialog genericDialog2 = new GenericDialog("Poisson NTF");
        genericDialog2.addNumericField("_Number of Iterations", (double)this.maxit, 0);
        genericDialog2.addNumericField("Subsamples", (double)this.subsamples, 0);
        genericDialog2.addNumericField("Segregation Bias", this.segbias, 0);
        genericDialog2.addNumericField("Saturation Threshold", this.saturation_threshold, 0);
        genericDialog2.addNumericField("_Background Threshold", this.bg_threshold, 0);
        this.add_spectra_choice(genericDialog2);
        genericDialog2.addMessage("\n");
        genericDialog2.addCheckbox("Specify Spectral Channels?", false);
        genericDialog2.setOKLabel("Run!");
        genericDialog2.showDialog();
        if (genericDialog2.wasCanceled()) {
            return this.CANCELLED;
        }
        this.maxit = (int)genericDialog2.getNextNumber();
        if (this.maxit < 1 || this.maxit > 10000) {
            IJ.error((String)"Bad number of Iterations!");
        }
        this.subsamples = (int)genericDialog2.getNextNumber();
        if (this.subsamples < 1) {
            this.subsamples = 1;
        }
        this.segbias = (float)genericDialog2.getNextNumber();
        this.saturation_threshold = (float)genericDialog2.getNextNumber();
        if (this.saturation_threshold < 0.0) {
            IJ.error((String)"Threshold has to be positive!");
        }
        this.bg_threshold = (float)genericDialog2.getNextNumber();
        if (this.bg_threshold < 0.0 || this.bg_threshold > this.saturation_threshold) {
            IJ.error((String)"Lower threshold has to be negative\nand below saturation!");
        }
        this.determine_channel_order();
        this.gauss_spectra();
        this.read_spectra_choice(genericDialog2);
        this.splice_spectra();
        if (genericDialog2.getNextBoolean()) {
            this.enter_emission_channels();
            this.determine_channel_order();
        }
        this.setPrefs();
        return 0;
    }

    private void gauss_spectra() {
        for (int i = 0; i < this.ndyes; ++i) {
            this.spectra_fixed[i] = false;
            float f = ((float)this.nemn - 1.0f) / ((float)this.ndyes + 1.0f) + 0.1f;
            for (int j = 1; j <= this.nemn; ++j) {
                int n = this.channel_order[j - 1];
                this.S[n][i] = 1.0 / ((double)f * Math.sqrt(Math.PI * 2)) * Math.exp(-0.5 * Math.pow((float)(j - 1) - (float)((i + 1) * this.nemn) / ((float)this.ndyes + 1.0f), 2.0) / Math.pow(f, 2.0)) * this.channel_width.get(n);
            }
        }
    }

    private int openLeicaSP2() {
        String string;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".tif");
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".txt");
            }
        };
        OpenDialog openDialog = new OpenDialog("Select one image of the series", null);
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return this.CANCELLED;
        }
        if (string2.endsWith(".txt") || string2.endsWith(".lei")) {
            IJ.showMessage((String)"Select one image of the desired series, not the *.txt or *.lei file");
            return this.openLeicaSP2();
        }
        String string3 = openDialog.getDirectory();
        File file = new File(string3);
        String[] stringArray = file.list(filenameFilter2);
        this.config_file = string3 + stringArray[0];
        this.read_excitations_LeicaSP2(this.config_file);
        try {
            string = string2.substring(string2.indexOf("Series"), string2.indexOf("Series") + 9);
        }
        catch (Exception exception) {
            IJ.showMessage((String)"Unable to extract series from file name");
            return this.CANCELLED;
        }
        String[] stringArray2 = file.list(filenameFilter);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            IJ.showProgress((int)i, (int)stringArray2.length);
            if (!stringArray2[i].contains(string)) continue;
            if (this.imageselected[n3]) {
                ImagePlus imagePlus = IJ.openImage((String)(string3 + stringArray2[i]));
                this.w = imagePlus.getWidth();
                this.h = imagePlus.getHeight();
                if (this.X[n] == null) {
                    this.X[n] = new ImageStack(this.w, this.h);
                }
                this.X[n].addSlice("Channel " + (n2 + 1) + ": " + this.ChannelsL.get(n).get(n2) + '-' + this.ChannelsR.get(n).get(n2) + "nm", imagePlus.getProcessor());
                if (++n2 == this.nchannels[n]) {
                    ++n;
                    n2 = 0;
                }
                if (n == this.nexc) break;
            }
            ++n3;
        }
        for (n = 0; n < this.nexc; ++n) {
            this.imp[n] = new ImagePlus("Excitation " + (n + 1) + ": " + this.excitation_wavelength.get(n), this.X[n]);
            this.imp[n].show();
        }
        return 0;
    }

    private int enter_emission_channels() {
        String string = "Enter emission channels.";
        GenericDialog genericDialog = new GenericDialog(string);
        for (int i = 0; i < this.nemn; ++i) {
            genericDialog.addNumericField("Channel " + Integer.toString(i + 1) + " lower boundary: ", this.emission_wavelength.get(i) - 0.5 * this.channel_width.get(i), 6);
            genericDialog.addNumericField("Channel " + Integer.toString(i + 1) + " upper boundary: ", this.emission_wavelength.get(i) - 0.5 * this.channel_width.get(i), 6);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return -1;
        }
        for (int i = 0; i < this.nemn; ++i) {
            double d = genericDialog.getNextNumber();
            double d2 = genericDialog.getNextNumber();
            this.emission_wavelength.set(i, 0.5 * (d + d2));
            this.channel_width.set(i, d2 - d);
        }
        return 0;
    }

    private int add_spectra_choice(GenericDialog genericDialog) {
        int n;
        int n2;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".emn");
            }
        };
        String string = System.getProperty("user.dir");
        string = string.concat("/plugins/SpectraLibrary");
        File file = new File(string);
        String[] stringArray = file.list(filenameFilter);
        String[] stringArray2 = new String[4];
        String[] stringArray3 = stringArray != null ? new String[stringArray.length + 4] : new String[4];
        stringArray2[0] = "Minimal values";
        stringArray2[1] = "ROI selection";
        stringArray2[2] = "manually";
        stringArray2[3] = "flat";
        stringArray3[0] = "Gaussian";
        stringArray3[1] = "ROI selection";
        stringArray3[2] = "manually";
        stringArray3[3] = "--------";
        for (int i = 4; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i - 4];
        }
        String string2 = stringArray2[0];
        String string3 = "_Background spectrum";
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (this.bg_choice == null || !this.bg_choice.equals(stringArray2[n2])) continue;
            string2 = stringArray2[n2];
        }
        genericDialog.addChoice(string3, stringArray2, string2);
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            string2 = stringArray3[0];
            for (n = 0; n < stringArray3.length; ++n) {
                if (this.spec_choice[n2] == null || !this.spec_choice[n2].equals(stringArray3[n])) continue;
                string2 = stringArray3[n];
            }
            string3 = "Dye_";
            string3 = string3.concat(Integer.toString(n2 + 1));
            string3 = string3.concat(" initial spectrum");
            genericDialog.addChoice(string3, stringArray3, string2);
        }
        String[] stringArray4 = new String[this.ndyes];
        genericDialog.addMessage("Keep spectra of dyes fixed?");
        for (n = 0; n < this.ndyes; ++n) {
            stringArray4[n] = "Dye ";
            stringArray4[n] = stringArray4[n].concat(Integer.toString(n + 1));
        }
        genericDialog.addCheckboxGroup(1, this.ndyes, stringArray4, this.spectra_fixed);
        return 0;
    }

    private int read_spectra_choice(GenericDialog genericDialog) {
        int n;
        int n2;
        int n3;
        int n4;
        String[] stringArray = new String[4];
        String string = System.getProperty("user.dir");
        string = string.concat("/plugins/SpectraLibrary");
        stringArray[0] = "Gaussian";
        stringArray[1] = "ROI selection";
        stringArray[2] = "manually";
        stringArray[3] = "--------";
        this.bg_choice = genericDialog.getNextChoice();
        this.getBackground(this.bg_choice);
        this.calcBgMask();
        this.gauss_spectra();
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            this.spec_choice[n4] = genericDialog.getNextChoice();
            if (this.spec_choice[n4].equals(stringArray[0]) || this.spec_choice[n4].equals(stringArray[3])) continue;
            if (this.spec_choice[n4].equals(stringArray[1])) {
                this.getSpectrum(n4);
                continue;
            }
            if (this.spec_choice[n4].equals(stringArray[2])) {
                this.enterSpectrum(n4);
                continue;
            }
            this.readSpectrum(n4, string, this.spec_choice[n4]);
        }
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            this.spectra_fixed[n4] = genericDialog.getNextBoolean();
        }
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            this.power[n4] = 0.0;
            for (n3 = 0; n3 < this.nemn; ++n3) {
                int n5 = n4;
                this.power[n5] = this.power[n5] + Math.pow(this.S[n3][n4], this.E);
            }
            this.power[n4] = (float)Math.pow(this.power[n4], 1.0 / this.E);
        }
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            for (n3 = 0; n3 < this.nemn; ++n3) {
                double[] dArray = this.S[n3];
                int n6 = n4;
                dArray[n6] = dArray[n6] / this.power[n4];
            }
        }
        for (n3 = 0; n3 < this.ndyes; ++n3) {
            for (n2 = 0; n2 < this.nemn; ++n2) {
                n4 = this.inverse_channel_order[n2];
                this.initialS[n2][n3] = (float)this.S[n4][n3];
            }
        }
        float f = 0.0f;
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nemn; ++n) {
                n4 = this.inverse_channel_order[n];
                if (!((double)this.initialS[n][n2] / this.channel_width.get(n4) > (double)f)) continue;
                f = (float)((double)this.initialS[n][n2] / this.channel_width.get(n4));
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nemn; ++n) {
                n4 = this.inverse_channel_order[n];
                this.initialS[n][n2] = (float)((double)this.initialS[n][n2] / this.channel_width.get(n4) / (double)f);
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nexc; ++n) {
                for (int i = 0; i < this.nchannels[n]; ++i) {
                    this.Sexc[n][i][n2] = this.S[this.channeltoemission[n][i]][n2];
                }
            }
        }
        return 0;
    }

    private int getBackground(String string) {
        if (string == null) {
            IJ.error((String)"Null pointer for background choice!");
            return this.BADVALUE;
        }
        String[] stringArray = new String[]{"Mininal values", "ROI selection", "manually", "flat"};
        int n = 0;
        if (string.equals(stringArray[1])) {
            int n2;
            new WaitForUserDialog("Background Selection", "Select Background ROI").show();
            Roi roi = null;
            int n3 = 0;
            for (n2 = 0; n2 < this.nexc; ++n2) {
                if (this.imp[n2].getRoi() == null) continue;
                roi = this.imp[n2].getRoi();
                n3 = this.imp[n2].getCurrentSlice();
            }
            --n3;
            n3 -= n3 % this.nemn;
            n = roi == null ? this.NOROISELECTED : this.GOODINPUT;
            if (n == this.GOODINPUT) {
                for (n2 = 0; n2 < this.nexc; ++n2) {
                    int n4;
                    int n5 = 0;
                    float f = 0.0f;
                    for (int i = 0; i < this.w; ++i) {
                        for (int j = 0; j < this.h; ++j) {
                            if (!roi.contains(i, j)) continue;
                            ++n5;
                            n4 = 0;
                            while (n4 < this.nchannels[n2]) {
                                f = ((float[])this.X[n2].getPixels(n3 + n4 + 1))[j * this.w + i];
                                double[] dArray = this.bg[n2];
                                int n6 = n4;
                                dArray[n6] = dArray[n6] + (double)f;
                                double[] dArray2 = this.bg_sigma[n2];
                                int n7 = n4++;
                                dArray2[n7] = dArray2[n7] + (double)(f * f);
                            }
                        }
                    }
                    for (n4 = 0; n4 < this.nchannels[n2]; ++n4) {
                        double[] dArray = this.bg[n2];
                        int n8 = n4;
                        dArray[n8] = dArray[n8] / (double)n5;
                        double[] dArray3 = this.bg_sigma[n2];
                        int n9 = n4;
                        dArray3[n9] = dArray3[n9] / (double)n5;
                        this.bg_sigma[n2][n4] = (float)Math.sqrt(this.bg_sigma[n2][n4] - this.bg[n2][n4] * this.bg[n2][n4]);
                    }
                }
            }
        } else if (string.equals(stringArray[2])) {
            n = this.enterSpectrum(-1);
        } else if (string.equals(stringArray[3])) {
            GenericDialog genericDialog = new GenericDialog("Background selection");
            genericDialog.addNumericField("Uniform Background:", 0.0, 0, 5, "counts");
            genericDialog.showDialog();
            float f = (float)genericDialog.getNextNumber();
            if (f > 0.0f && (double)f < this.saturation_threshold) {
                n = 1;
                for (int i = 0; i < this.nexc; ++i) {
                    for (int j = 0; j < this.nemn; ++j) {
                        this.bg[i][j] = f;
                        this.bg_sigma[i][j] = 1.0;
                    }
                }
            } else {
                n = this.BADVALUE;
            }
        }
        if (n == this.GOODINPUT) {
            return 0;
        }
        this.minimumBackground();
        if (n == this.NOROISELECTED) {
            IJ.showMessage((String)"No ROI selected! Using minimal signal instead!");
            return -1;
        }
        if (n == this.BADVALUE) {
            IJ.showMessage((String)"Invalid value! Using minimal signal instead!");
            return -2;
        }
        return 0;
    }

    private void splice_spectra() {
        int n;
        int n2;
        int n3;
        int n4;
        double[][][] dArray = new double[this.nexc][this.nexc][this.ndyes];
        double[][][] dArray2 = new double[this.nexc][this.nexc][this.ndyes];
        for (n4 = 0; n4 < this.nexc; ++n4) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < this.ndyes; ++n2) {
                    dArray[n4][n3][n2] = 0.0;
                    dArray2[n4][n3][n2] = 0.0;
                }
            }
        }
        for (n4 = 0; n4 < this.nexc; ++n4) {
            for (n3 = 0; n3 < this.nexc; ++n3) {
                for (n = 0; n < this.nchannels[n4]; ++n) {
                    for (int i = 0; i < this.nchannels[n3]; ++i) {
                        if (this.channeltoemission[n4][n] != this.channeltoemission[n3][i]) continue;
                        for (n2 = 0; n2 < this.ndyes; ++n2) {
                            double[] dArray3 = dArray[n4][n3];
                            int n5 = n2;
                            dArray3[n5] = dArray3[n5] + this.Sexc[n4][n][n2];
                            double[] dArray4 = dArray2[n4][n3];
                            int n6 = n2;
                            dArray4[n6] = dArray4[n6] + this.Sexc[n3][i][n2];
                        }
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.nexc; ++n4) {
            for (n2 = 0; n2 < this.ndyes; ++n2) {
                this.Q[n4][n2] = n4 == 0 ? 1.0 : this.Q[n4 - 1][n2] * dArray2[n4 - 1][n4][n2] / dArray[n4 - 1][n4][n2];
            }
        }
        double[][] dArray5 = new double[this.nemn][this.ndyes];
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nemn; ++n) {
                this.S[n][n2] = 0.0;
                dArray5[n][n2] = 0.0;
            }
        }
        for (n4 = 0; n4 < this.nexc; ++n4) {
            for (n2 = 0; n2 < this.ndyes; ++n2) {
                for (n = 0; n < this.nchannels[n4]; ++n) {
                    double[] dArray6 = this.S[this.channeltoemission[n4][n]];
                    int n7 = n2;
                    dArray6[n7] = dArray6[n7] + this.Sexc[n4][n][n2];
                    double[] dArray7 = dArray5[this.channeltoemission[n4][n]];
                    int n8 = n2;
                    dArray7[n8] = dArray7[n8] + this.Q[n4][n2];
                }
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nemn; ++n) {
                double[] dArray8 = this.S[n];
                int n9 = n2;
                dArray8[n9] = dArray8[n9] / dArray5[n][n2];
            }
        }
    }

    private int getSpectrum(int n) {
        int n2;
        String string = "Select a ROI for dye ";
        string = string.concat(Integer.toString(n + 1));
        new WaitForUserDialog("Start Spectra", string).show();
        Roi roi = null;
        int n3 = 0;
        for (n2 = 0; n2 < this.nexc; ++n2) {
            if (this.imp[n2].getRoi() == null) continue;
            roi = this.imp[n2].getRoi();
            n3 = this.imp[n2].getCurrentSlice();
        }
        --n3;
        n3 -= n3 % this.nemn;
        boolean bl = roi != null;
        if (bl) {
            int n4;
            int n5 = 0;
            for (n2 = 0; n2 < this.nexc; ++n2) {
                for (n4 = 0; n4 < this.nemn; ++n4) {
                    this.Sexc[n2][n4][n] = 0.0;
                }
            }
            for (int i = 0; i < this.w; ++i) {
                for (int j = 0; j < this.h; ++j) {
                    if (!roi.contains(i, j)) continue;
                    ++n5;
                    for (n2 = 0; n2 < this.nexc; ++n2) {
                        for (n4 = 0; n4 < this.nchannels[n2]; ++n4) {
                            float f = ((float[])this.X[n2].getPixels(n3 + n4 + 1))[j * this.w + i];
                            double[] dArray = this.Sexc[n2][n4];
                            int n6 = n;
                            dArray[n6] = dArray[n6] + (double)f;
                        }
                    }
                }
            }
            for (n2 = 0; n2 < this.nexc; ++n2) {
                for (n4 = 0; n4 < this.nemn; ++n4) {
                    double[] dArray = this.Sexc[n2][n4];
                    int n7 = n;
                    dArray[n7] = dArray[n7] / (double)n5;
                }
            }
            for (n2 = 0; n2 < this.nexc; ++n2) {
                for (n4 = 0; n4 < this.nchannels[n2]; ++n4) {
                    double[] dArray = this.Sexc[n2][n4];
                    int n8 = n;
                    dArray[n8] = dArray[n8] - this.bg[n2][n4];
                }
            }
            return this.GOODINPUT;
        }
        IJ.showMessage((String)"Select ROI!");
        return this.NOROISELECTED;
    }

    private void readSpectrum(int n, String string, String string2) {
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + "/" + string2));
            Vector<Double> vector = new Vector<Double>();
            Vector<Double> vector2 = new Vector<Double>();
            while ((string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                if (stringTokenizer.countTokens() <= 1) continue;
                vector.addElement(Double.valueOf(stringTokenizer.nextToken()));
                vector2.addElement(Double.valueOf(stringTokenizer.nextToken()));
            }
            bufferedReader.close();
            int n2 = 0;
            for (n2 = 0; n2 < this.nemn; ++n2) {
                double d = this.channel_width.get(n2) / 20.0;
                double d2 = 0.0;
                for (double d3 = this.emission_wavelength.get(n2) - 0.5 * this.channel_width.get(n2); d3 < this.emission_wavelength.get(n2) + 0.5 * this.channel_width.get(n2); d3 += d) {
                    d2 += this.interpolate(vector, vector2, d3 + 0.5 * d) * d;
                }
                this.S[n2][n] = d2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IJ.error((String)"File not found");
        }
        catch (IOException iOException) {
            IJ.error((String)"Bad file!");
        }
    }

    private double interpolate(Vector<Double> vector, Vector<Double> vector2, double d) {
        double d2 = 0.0;
        if (d < vector.get(0)) {
            double d3 = vector.get(0);
            double d4 = vector.get(1);
            double d5 = vector2.get(0);
            double d6 = vector2.get(1);
            d2 = d5 + (d6 - d5) / (d4 - d3) * (d - d3);
        } else if (d > vector.get(vector.size() - 1)) {
            double d7 = vector.get(vector.size() - 2);
            double d8 = vector.get(vector.size() - 1);
            double d9 = vector2.get(vector.size() - 2);
            double d10 = vector2.get(vector.size() - 1);
            d2 = d9 + (d10 - d9) / (d8 - d7) * (d - d7);
        } else {
            int n;
            for (n = 0; n < vector.size() && vector.get(n) < d; ++n) {
            }
            if (vector2.size() > n) {
                double d11 = vector.get(n - 1);
                double d12 = vector.get(n);
                double d13 = vector2.get(n - 1);
                double d14 = vector2.get(n);
                d2 = d13 + (d14 - d13) / (d12 - d11) * (d - d11);
            } else {
                d2 = 0.0;
            }
        }
        return Math.max(d2, 0.0);
    }

    private void minimumBackground() {
        for (int i = 0; i < this.nexc; ++i) {
            for (int j = 0; j < this.nchannels[i]; ++j) {
                for (int k = 0; k < this.tz_dim; ++k) {
                    int n = k * this.nemn + j + 1;
                    float f = (float)this.saturation_threshold;
                    for (int i2 = 0; i2 < this.wh; ++i2) {
                        if (!(((float[])this.X[i].getPixels(n))[i2] < f)) continue;
                        f = ((float[])this.X[i].getPixels(n))[i2];
                    }
                    this.bg[i][j] = f;
                }
            }
        }
    }

    private int enterSpectrum(int n) {
        int n2;
        String string = "Enter spectrum of dye ";
        string = string.concat(Integer.toString(n + 1));
        GenericDialog genericDialog = new GenericDialog(string);
        for (n2 = 0; n2 < this.nemn; ++n2) {
            genericDialog.addNumericField(Integer.toString(n2 + 1), this.S[n2][n], 4);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return this.CANCELLED;
        }
        for (n2 = 0; n2 < this.nemn; ++n2) {
            this.S[n2][n] = genericDialog.getNextNumber();
            if (!(this.S[n2][n] < this.spec_nothing)) continue;
            this.S[n2][n] = this.spec_nothing;
        }
        for (n2 = 0; n2 < this.nexc; ++n2) {
            for (int i = 0; i < this.nchannels[n2]; ++i) {
                this.Sexc[n2][i][n] = this.S[this.channeltoemission[n2][i]][n];
            }
        }
        return this.GOODINPUT;
    }

    private void calcBgMask() {
        for (int i = 0; i < this.tz_dim; ++i) {
            int n;
            int n2 = i * this.wh;
            for (n = 0; n < this.wh; ++n) {
                this.bgMask[n + n2] = this.totalchannels;
            }
            for (int j = 0; j < this.nexc; ++j) {
                for (int k = 0; k < this.nchannels[j]; ++k) {
                    int n3 = i * this.nemn + k + 1;
                    for (n = 0; n < this.wh; ++n) {
                        if ((double)((float[])this.X[j].getPixels(n3))[n] < this.bg[j][k] + this.no_std * this.bg_sigma[j][k] + this.bg_threshold) {
                            int n4 = n2 + n;
                            this.bgMask[n4] = this.bgMask[n4] - 1;
                        }
                        if (!((double)((float[])this.X[j].getPixels(n3))[n] > this.saturation_threshold)) continue;
                        int n5 = n2 + n;
                        this.bgMask[n5] = this.bgMask[n5] - 2 * this.totalchannels;
                    }
                }
            }
        }
    }

    private void determine_exc_channel_map() {
        for (int i = 0; i < this.nemn; ++i) {
            int n = this.nexc;
            int n2 = 0;
            for (int j = 0; j < this.nexc; ++j) {
                for (int k = 0; k < this.nchannels[j]; ++k) {
                    if (this.channeltoemission[j][k] != i) continue;
                    if (j < n) {
                        n = j;
                    }
                    if (j <= n2) continue;
                    n2 = j;
                }
            }
            this.lowerexc[i] = n;
            this.upperexc[i] = n2 + 1;
        }
    }

    private int read_excitations_LeicaSP2(String string) {
        int n = 4;
        this.excitation_wavelength = new Vector();
        try {
            int n2;
            int n3;
            int n4;
            Object object;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            for (int i = 0; i < n; ++i) {
                vector3.add(null);
                vector3.set(vector3.size() - 1, new Vector());
                vector4.add(null);
                vector4.set(vector4.size() - 1, new Vector());
            }
            int n5 = 1;
            String string3 = "HARDWARE PARAMETER #0 SEQUENCE ";
            while ((string2 = bufferedReader.readLine()) != null && !string2.contains(string3 + n5)) {
            }
            vector.add("");
            int n6 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                double d;
                String string4;
                StringTokenizer stringTokenizer;
                if (string2.contains("AOTF")) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    object = stringTokenizer.nextToken();
                    d = 0.0;
                    try {
                        d = Double.valueOf((String)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (d > 0.01) {
                        vector.set(n5 - 1, (String)vector.get(n5 - 1) + string4);
                    }
                }
                if (string2.contains("SP Mirror")) {
                    stringTokenizer = new StringTokenizer(string2);
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    object = stringTokenizer.nextToken();
                    d = 0.0;
                    try {
                        d = Double.valueOf((String)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string4.equals("(left)")) {
                        ((Vector)vector3.get(n6)).add(d);
                    } else if (string4.equals("(right)")) {
                        ((Vector)vector4.get(n6)).add(d);
                        ++n6;
                    }
                }
                if (!string2.contains(string3)) continue;
                ++n5;
                vector.add("");
                n6 = 0;
            }
            int n7 = vector.size();
            object = new GenericDialog("Poisson NTF");
            this.imageselected = new boolean[n * ((Vector)vector3.get(0)).size() + 1];
            String[] stringArray = new String[n7];
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = 0; n3 < ((Vector)vector3.get(n4)).size(); ++n3) {
                    this.imageselected[n * n3 + n4] = true;
                }
            }
            for (n3 = 0; n3 < n7; ++n3) {
                stringArray[n3] = (String)vector.get(n3);
            }
            object.addCheckboxGroup(n7, 1, stringArray, this.imageselected);
            object.showDialog();
            if (object.wasCanceled()) {
                return this.CANCELLED;
            }
            n4 = 0;
            for (n3 = 0; n3 < n7; ++n3) {
                if (object.getNextBoolean()) continue;
                vector.remove(n3 - n4);
                --n5;
                for (int i = 0; i < n; ++i) {
                    this.imageselected[n * n3 + i] = false;
                    ((Vector)vector3.get(i)).remove(n3 - n4);
                    ((Vector)vector4.get(i)).remove(n3 - n4);
                }
                ++n4;
            }
            this.nexc = 0;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                n4 = 0;
                int n8 = -1;
                for (int i = 0; i < n3; ++i) {
                    if (!((String)vector.get(n3)).equals(vector.get(i))) continue;
                    ++n4;
                    if (n8 >= 0) continue;
                    n8 = i;
                }
                this.excitation_wavelength.add((String)vector.get(n3));
                vector2.add(n3);
                ++this.nexc;
            }
            this.allocate_nexc_dependent();
            for (n4 = 0; n4 < n5; ++n4) {
                for (int i = 0; i < n; ++i) {
                    this.ChannelsL.get((Integer)vector2.get(n4)).add((Double)((Vector)vector3.get(i)).get(n4));
                    this.ChannelsR.get((Integer)vector2.get(n4)).add((Double)((Vector)vector4.get(i)).get(n4));
                }
            }
            this.emission_wavelength = new Vector();
            this.channel_width = new Vector();
            for (n3 = 0; n3 < this.ChannelsL.size(); ++n3) {
                this.nchannels[n3] = this.ChannelsL.get(n3).size();
                for (n2 = 0; n2 < this.nchannels[n3]; ++n2) {
                    double d = 0.5 * (this.ChannelsL.get(n3).get(n2) + this.ChannelsR.get(n3).get(n2));
                    double d2 = this.ChannelsR.get(n3).get(n2) - this.ChannelsL.get(n3).get(n2);
                    if (this.emission_wavelength.contains(d)) continue;
                    this.emission_wavelength.add(d);
                    this.channel_width.add(d2);
                }
            }
            this.nemn = this.emission_wavelength.size();
            this.allocate_nemn_dependent();
            for (n3 = 0; n3 < this.ChannelsL.size(); ++n3) {
                for (n2 = 0; n2 < this.nchannels[n3]; ++n2) {
                    double d = 0.5 * (this.ChannelsL.get(n3).get(n2) + this.ChannelsR.get(n3).get(n2));
                    this.channeltoemission[n3][n2] = this.emission_wavelength.indexOf(d);
                }
            }
            this.determine_exc_channel_map();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0;
        }
        catch (IOException iOException) {
            return 0;
        }
        return 0;
    }

    private void determine_channel_order() {
        int n;
        double d = -1.0;
        int n2 = 0;
        for (n = 0; n < this.nemn; ++n) {
            double d2 = 1000.0;
            for (int i = 0; i < this.nemn; ++i) {
                if (!(this.emission_wavelength.get(i) < d2) || !(this.emission_wavelength.get(i) > d)) continue;
                d2 = this.emission_wavelength.get(i);
                n2 = i;
            }
            this.channel_order[n] = n2;
            d = d2;
        }
        for (n = 0; n < this.nemn; ++n) {
            this.inverse_channel_order[this.channel_order[n]] = n;
        }
    }

    public void plotEmissionSpectra() {
        int n;
        int n2;
        int n3;
        double[][] dArray = new double[this.nemn][this.ndyes];
        for (n3 = 0; n3 < this.ndyes; ++n3) {
            for (n2 = 0; n2 < this.nemn; ++n2) {
                n = this.channel_order[n2];
                dArray[n2][n3] = this.S[n][n3];
            }
        }
        Color[] colorArray = new Color[]{Color.blue, Color.green, Color.red, Color.cyan, Color.gray, Color.darkGray};
        Plot plot = new Plot("PoissonNTF emission spectra", "wave length [nm]", "intensity", (float[])null, (float[])null, 2);
        if (this.plotEmission == null) {
            this.plotEmission = new PlotWindow("PoissonNTF emission spectra", "wave length [nm]", "intensity", (float[])null, (float[])null);
        }
        float[] fArray = new float[this.nemn];
        float[] fArray2 = new float[this.nemn];
        for (n2 = 0; n2 < fArray2.length; ++n2) {
            n = this.channel_order[n2];
            fArray2[n2] = (float)this.emission_wavelength.get(n).doubleValue();
        }
        plot.setLimits(this.emission_wavelength.get(this.channel_order[0]).doubleValue(), this.emission_wavelength.get(this.channel_order[this.nemn - 1]).doubleValue(), 0.0, 1.0);
        int n4 = 0;
        float f = 0.0f;
        for (n3 = 0; n3 < this.ndyes; ++n3) {
            for (n2 = 0; n2 < this.nemn; ++n2) {
                n = this.inverse_channel_order[n2];
                if (!(dArray[n2][n3] / this.channel_width.get(n) > (double)f)) continue;
                f = (float)((double)((float)dArray[n2][n3]) / this.channel_width.get(n));
            }
        }
        for (n3 = 0; n3 < this.ndyes; ++n3) {
            for (n2 = 0; n2 < this.nemn; ++n2) {
                n = this.inverse_channel_order[n2];
                fArray[n2] = (float)(dArray[n2][n3] / this.channel_width.get(n) / (double)f);
            }
            plot.setLineWidth(2);
            plot.setColor(colorArray[n4]);
            plot.addPoints(fArray2, fArray, 2);
            for (n2 = 0; n2 < this.nemn; ++n2) {
                n = this.inverse_channel_order[n2];
                fArray[n2] = this.initialS[n2][n3];
            }
            plot.setLineWidth(1);
            plot.addPoints(fArray2, fArray, 2);
            if (n4++ <= colorArray.length) continue;
            n4 = 0;
        }
        plot.draw();
        this.plotEmission.drawPlot(plot);
    }

    public void plotExcitationSpectra() {
        int n;
        int n2;
        double[][] dArray = new double[this.nexc][this.ndyes];
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nexc; ++n) {
                dArray[n][n2] = this.Q[n][n2];
            }
        }
        Color[] colorArray = new Color[]{Color.blue, Color.green, Color.red, Color.cyan, Color.gray, Color.darkGray};
        Plot plot = new Plot("PoissonNMF excitation spectra", "Excitation", "intensity", (float[])null, (float[])null, 2);
        if (this.plotExcitation == null) {
            this.plotExcitation = new PlotWindow("PoissonNTF excitation spectra", "Excitation", "intensity", (float[])null, (float[])null);
        }
        float[] fArray = new float[this.nexc];
        float[] fArray2 = new float[this.nexc];
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = (float)n + 1.0f;
        }
        int n3 = 0;
        float f = 0.0f;
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nexc; ++n) {
                if (!(dArray[n][n2] > (double)f)) continue;
                f = (float)dArray[n][n2];
            }
        }
        plot.setLimits((double)fArray2[0] - 0.5, (double)fArray2[n - 1] + 0.5, 0.0, (double)f);
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.nexc; ++n) {
                fArray[n] = (float)dArray[n][n2];
            }
            plot.setLineWidth(2);
            plot.setColor(colorArray[n3]);
            plot.addPoints(fArray2, fArray, 2);
            if (n3++ <= colorArray.length) continue;
            n3 = 0;
        }
        plot.draw();
        this.plotExcitation.drawPlot(plot);
    }

    public PlotWindow plotbg() {
        int n;
        int n2;
        Color[] colorArray = new Color[]{Color.blue, Color.green, Color.red};
        Plot plot = new Plot("Poisson NMF background spectra", "wave length [nm]", "intensity", (float[])null, (float[])null, 2);
        double[] dArray = new double[this.nemn];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = this.emission_wavelength.get(n2);
        }
        double d = this.saturation_threshold;
        double d2 = 0.0;
        for (n = 0; n < this.nexc; ++n) {
            for (n2 = 0; n2 < this.nchannels[n]; ++n2) {
                if (this.bg[n][n2] > d2) {
                    d2 = this.bg[n][n2];
                }
                if (!(this.bg[n][n2] < d)) continue;
                d = this.bg[n][n2];
            }
        }
        if (d == d2) {
            d -= 5.0;
            d2 += 5.0;
        }
        plot.setLimits(this.emission_wavelength.get(0).doubleValue(), this.emission_wavelength.get(this.nemn - 1).doubleValue(), d, d2);
        for (n = 0; n < this.nexc; ++n) {
            float[] fArray = new float[this.nchannels[n]];
            float[] fArray2 = new float[this.nchannels[n]];
            for (n2 = 0; n2 < this.nchannels[n]; ++n2) {
                fArray[n2] = (float)this.emission_wavelength.get(this.channeltoemission[n][n2]).doubleValue();
                fArray2[n2] = (float)this.bg[n][n2];
            }
            plot.setLineWidth(2);
            plot.setColor(colorArray[n % 3]);
            plot.addPoints(fArray, fArray2, 2);
        }
        return plot.show();
    }

    public void RGB_overlay() {
        int n;
        int[] nArray = new int[3];
        GenericDialog genericDialog = new GenericDialog("Select Sources");
        if (this.ndyes > 2) {
            genericDialog.addNumericField("Blue:", 1.0, 0);
            genericDialog.addNumericField("Green:", 2.0, 0);
            genericDialog.addNumericField("Red:", 3.0, 0);
        } else {
            genericDialog.addNumericField("Green:", 1.0, 0);
            genericDialog.addNumericField("Red:", 2.0, 0);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        if (this.isHyperstack) {
            n = this.img.getCurrentSlice();
            --n;
            n -= n % this.ndyes;
        } else {
            n = 0;
        }
        nArray[0] = (int)genericDialog.getNextNumber();
        nArray[1] = (int)genericDialog.getNextNumber();
        if (this.ndyes > 2) {
            nArray[2] = (int)genericDialog.getNextNumber();
        }
        for (int i = 0; i < Math.min(this.ndyes, 3); ++i) {
            if (nArray[i] <= this.ndyes && nArray[i] >= 1) continue;
            IJ.showMessage((String)"Invalid source number!");
            return;
        }
        ImagePlus imagePlus = null;
        imagePlus = NewImage.createRGBImage((String)"Overlay of concentrations", (int)this.w, (int)this.h, (int)1, (int)1);
        if (this.ndyes > 2) {
            for (int i = 0; i < this.wh; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int[] nArray2 = (int[])imagePlus.getProcessor().getPixels();
                    int n2 = i;
                    nArray2[n2] = nArray2[n2] + ((int)(255.0 * Math.min((double)Math.abs(((float[])this.A.getPixels(n + nArray[j]))[i]), 1.0)) << 8 * j);
                }
            }
        } else {
            for (int i = 0; i < this.wh; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int[] nArray3 = (int[])imagePlus.getProcessor().getPixels();
                    int n3 = i;
                    nArray3[n3] = nArray3[n3] + ((int)(255.0 * Math.min((double)Math.abs(((float[])this.A.getPixels(n + nArray[j]))[i]), 1.0)) << 8 * (j + 1));
                }
            }
        }
        imagePlus.show();
        imagePlus.updateAndDraw();
    }

    public void BG_map() {
        int n;
        ImagePlus imagePlus = null;
        imagePlus = NewImage.createRGBImage((String)"Background and saturated regions", (int)this.w, (int)this.h, (int)1, (int)1);
        if (this.isHyperstack) {
            n = this.img.getCurrentSlice();
            --n;
            n -= n % this.ndyes;
            n /= this.ndyes;
            n *= this.wh;
        } else {
            n = 0;
        }
        for (int i = 0; i < this.wh; ++i) {
            ((int[])imagePlus.getProcessor().getPixels())[i] = this.bgMask[n + i] == 2 * this.totalchannels ? 32768 : (this.bgMask[n + i] >= 0 ? 128 : 0x800000);
        }
        imagePlus.show();
        imagePlus.updateAndDraw();
    }

    private void showConcentrations() {
        int n;
        int n2;
        int n3 = 0;
        this.segbias = 0.0;
        for (n2 = 0; n2 < this.no_postiterations; ++n2) {
            this.updateA_NTF();
        }
        this.A = new ImageStack(this.w, this.h);
        for (n2 = 0; n2 < this.tz_dim; ++n2) {
            for (n = 0; n < this.ndyes; ++n) {
                this.A.addSlice("source " + (n + 1), (ImageProcessor)new FloatProcessor(this.w, this.h));
            }
        }
        this.normalizeNTF_maxConc();
        this.calc_pinv();
        double[] dArray = new double[this.ndyes];
        for (int i = 0; i < this.tz_dim; ++i) {
            int n4 = i * this.wh;
            int n5 = i * this.ndyes;
            for (int j = 0; j < this.wh; ++j) {
                if (this.bgMask[n4 + j] == 2 * this.totalchannels) {
                    for (n = 0; n < this.ndyes; ++n) {
                        ((float[])this.A.getPixels((int)(n5 + n + 1)))[j] = (float)this.Asub[n3][n];
                    }
                    ++n3;
                    continue;
                }
                for (n = 0; n < this.ndyes; ++n) {
                    dArray[n] = 0.0;
                    int n6 = 0;
                    for (int k = 0; k < this.nexc; ++k) {
                        int n7 = i * this.nchannels[k];
                        for (int i2 = 0; i2 < this.nchannels[k]; ++i2) {
                            int n8 = n;
                            dArray[n8] = dArray[n8] + this.pinvS[n][n6] * ((double)((float[])this.X[k].getPixels(n7 + i2 + 1))[j] - this.bg[k][i2]);
                            ++n6;
                        }
                    }
                }
                for (n = 0; n < this.ndyes; ++n) {
                    ((float[])this.A.getPixels((int)(n5 + n + 1)))[j] = (float)dArray[n];
                }
            }
        }
        this.img = new ImagePlus("NTF sources", this.A);
        if (this.isHyperstack) {
            this.img.setDimensions(this.ndyes, this.dim[0][3], this.dim[0][4]);
            this.img.setOpenAsHyperStack(true);
        }
        this.img.show();
        this.img.updateAndDraw();
    }

    private void allocate_nexc_dependent() {
        this.ChannelsL = new Vector();
        this.ChannelsR = new Vector();
        for (int i = 0; i < this.nexc; ++i) {
            this.ChannelsL.add(null);
            this.ChannelsL.set(i, new Vector());
            this.ChannelsR.add(null);
            this.ChannelsR.set(i, new Vector());
        }
        this.dim = new int[this.nexc][5];
        this.nchannels = new int[this.nexc];
        this.imp = new ImagePlus[this.nexc];
        this.X = new ImageStack[this.nexc];
    }

    private void allocate_ndyes_dependent() {
        this.S = new double[this.nemn][this.ndyes];
        this.Sexc = new double[this.nexc][this.nemn][this.ndyes];
        this.Q = new double[this.nexc][this.ndyes];
        this.initialS = new float[this.nemn][this.ndyes];
        this.spectra_fixed = new boolean[this.ndyes];
        this.power = new double[this.ndyes];
        this.spec_choice = new String[this.ndyes];
        for (int i = 0; i < this.nexc; ++i) {
            this.totalchannels += this.nchannels[i];
        }
        this.pinvS = new double[this.ndyes][this.totalchannels];
    }

    private void allocate_nemn_dependent() {
        this.channeltoemission = new int[this.nexc][this.nemn];
        this.bg = new double[this.nexc][this.nemn];
        this.bg_sigma = new double[this.nexc][this.nemn];
        this.channel_order = new int[this.nemn];
        this.inverse_channel_order = new int[this.nemn];
        this.lowerexc = new int[this.nemn];
        this.upperexc = new int[this.nemn];
    }

    private void getPrefs() {
        this.maxit = (int)Prefs.get((String)"PoissonNTF.maxit", (double)this.maxit);
        this.segbias = Prefs.get((String)"PoissonNTF.segbias", (double)this.segbias);
        this.saturation_threshold = Prefs.get((String)"PoissonNTF.saturation_threshold", (double)this.saturation_threshold);
        this.bg_threshold = Prefs.get((String)"PoissonNTF.bg_threshold", (double)this.bg_threshold);
        this.bg_choice = Prefs.get((String)"PoissonNTF.bg_choice", (String)"none");
        this.subsamples = (int)Prefs.get((String)"PoissonNTF.subsamples", (double)this.subsamples);
        if ((int)Prefs.get((String)"PoissonNTF.ndyes", (double)0.0) == this.ndyes) {
            for (int i = 0; i < this.ndyes; ++i) {
                String string = "PoissonNTF.Dye_";
                string = string.concat(Integer.toString(i + 1));
                this.spec_choice[i] = Prefs.get((String)string, (String)"none");
                string = "PoissonNTF.DyeFixed_";
                string = string.concat(Integer.toString(i + 1));
                this.spectra_fixed[i] = Prefs.get((String)string, (boolean)false);
            }
        }
    }

    private void setPrefs() {
        Prefs.set((String)"PoissonNTF.maxit", (int)this.maxit);
        Prefs.set((String)"PoissonNTF.segbias", (double)this.segbias);
        Prefs.set((String)"PoissonNTF.saturation_threshold", (double)this.saturation_threshold);
        Prefs.set((String)"PoissonNTF.bg_threshold", (double)this.bg_threshold);
        Prefs.set((String)"PoissonNTF.bg_choice", (String)this.bg_choice);
        Prefs.set((String)"PoissonNTF.subsamples", (int)this.subsamples);
        Prefs.set((String)"PoissonNTF.ndyes", (int)this.ndyes);
        for (int i = 0; i < this.ndyes; ++i) {
            String string = "PoissonNTF.Dye_";
            string = string.concat(Integer.toString(i + 1));
            Prefs.set((String)string, (String)this.spec_choice[i]);
            string = "PoissonNTF.DyeFixed_";
            string = string.concat(Integer.toString(i + 1));
            Prefs.set((String)string, (boolean)this.spectra_fixed[i]);
        }
    }

    public int saveEmissionSpectra() {
        int n;
        GenericDialog genericDialog = new GenericDialog("Save some spectra?");
        String[] stringArray = new String[this.ndyes];
        Boolean[] booleanArray = new Boolean[this.ndyes];
        for (n = 0; n < this.ndyes; ++n) {
            stringArray[n] = "Save spectrum " + new Integer(n + 1).toString() + "?";
            genericDialog.addCheckbox(stringArray[n], true);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return this.CANCELLED;
        }
        for (n = 0; n < this.ndyes; ++n) {
            booleanArray[n] = genericDialog.getNextBoolean();
        }
        for (n = 0; n < booleanArray.length; ++n) {
            if (!booleanArray[n].booleanValue()) continue;
            SaveDialog saveDialog = new SaveDialog("Save spectrum as ...", "spectrum" + new Integer(n + 1).toString(), ".emn");
            String string = saveDialog.getDirectory();
            String string2 = saveDialog.getFileName();
            if (string2 == null) {
                return -1;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + string2));
                for (int i = 0; i < this.nemn; ++i) {
                    bufferedWriter.write(new Float(this.emission_wavelength.get(i)).toString() + "\t" + new Float(this.S[i][n] / this.channel_width.get(i)).toString() + "\t");
                    bufferedWriter.write("\n");
                }
                bufferedWriter.close();
                continue;
            }
            catch (Exception exception) {
                IJ.error((String)"Error while saving spectra:", (String)exception.getMessage());
            }
        }
        return 0;
    }

    public int saveExcitationSpectra() {
        int n;
        GenericDialog genericDialog = new GenericDialog("Save some spectra?");
        String[] stringArray = new String[this.ndyes];
        Boolean[] booleanArray = new Boolean[this.ndyes];
        for (n = 0; n < this.ndyes; ++n) {
            stringArray[n] = "Save excitation spectrum " + new Integer(n + 1).toString() + "?";
            genericDialog.addCheckbox(stringArray[n], true);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return this.CANCELLED;
        }
        for (n = 0; n < this.ndyes; ++n) {
            booleanArray[n] = genericDialog.getNextBoolean();
        }
        for (n = 0; n < booleanArray.length; ++n) {
            if (!booleanArray[n].booleanValue()) continue;
            SaveDialog saveDialog = new SaveDialog("Save spectrum as ...", "spectrum" + new Integer(n + 1).toString(), ".exc");
            String string = saveDialog.getDirectory();
            String string2 = saveDialog.getFileName();
            if (string2 == null) {
                return -1;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + string2));
                for (int i = 0; i < this.nexc; ++i) {
                    bufferedWriter.write(new Float(this.emission_wavelength.get(i)).toString() + "\t" + new Float(this.Q[i][n] / this.channel_width.get(i)).toString() + "\t");
                    bufferedWriter.write("\n");
                }
                bufferedWriter.close();
                continue;
            }
            catch (Exception exception) {
                IJ.error((String)"Error while saving spectra:", (String)exception.getMessage());
            }
        }
        return 0;
    }

    void showAbout() {
        IJ.showMessage((String)"About PoissonNTF...", (String)("An ImageJ plugin for separating multiple dyes from an image stack. Version " + this.PoissonNTFversion));
    }

    private void calc_pinv() {
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        double[][] dArray = new double[this.ndyes][this.ndyes];
        double[][] dArray2 = new double[this.ndyes][this.ndyes];
        double[] dArray3 = new double[this.ndyes];
        for (n8 = 0; n8 < dArray.length; ++n8) {
            for (n7 = 0; n7 < dArray[n8].length; ++n7) {
                dArray[n8][n7] = 0.0;
                for (n6 = 0; n6 < this.nexc; ++n6) {
                    for (n5 = 0; n5 < this.nchannels[n6]; ++n5) {
                        double[] dArray4 = dArray[n8];
                        int n9 = n7;
                        dArray4[n9] = dArray4[n9] + this.Q[n6][n8] * this.S[this.channeltoemission[n6][n5]][n8] * this.Q[n6][n7] * this.S[this.channeltoemission[n6][n5]][n7];
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.ndyes; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                d += dArray2[n4][n3] * dArray2[n4][n3];
            }
            double d2 = dArray[n4][n4] - d;
            dArray2[n4][n4] = Math.sqrt(d2);
            for (int i = n4 + 1; i < this.ndyes; ++i) {
                d = 0.0;
                for (n3 = 0; n3 < n4; ++n3) {
                    d += dArray2[i][n3] * dArray2[n4][n3];
                }
                dArray2[i][n4] = (dArray[i][n4] - d) / dArray2[n4][n4];
                dArray2[n4][i] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = 0; n < this.ndyes; ++n) {
                dArray3[n] = 0.0;
            }
            dArray3[n2] = 1.0;
            for (n4 = 0; n4 < this.ndyes; ++n4) {
                d = 0.0;
                for (n3 = 0; n3 < n4; ++n3) {
                    d += dArray2[n4][n3] * dArray[n3][n2];
                }
                dArray[n4][n2] = (dArray3[n4] - d) / dArray2[n4][n4];
            }
        }
        for (n2 = 0; n2 < this.ndyes; ++n2) {
            for (n = n2; n < this.ndyes; ++n) {
                dArray2[n2][n] = 0.0;
                for (n3 = n; n3 < this.ndyes; ++n3) {
                    double[] dArray5 = dArray2[n2];
                    int n10 = n;
                    dArray5[n10] = dArray5[n10] + dArray[n3][n2] * dArray[n3][n];
                }
                dArray2[n][n2] = dArray2[n2][n];
            }
        }
        for (n8 = 0; n8 < this.ndyes; ++n8) {
            int n11 = 0;
            for (n6 = 0; n6 < this.nexc; ++n6) {
                for (n5 = 0; n5 < this.nchannels[n6]; ++n5) {
                    this.pinvS[n8][n11] = 0.0;
                    for (n7 = 0; n7 < this.ndyes; ++n7) {
                        double[] dArray6 = this.pinvS[n8];
                        int n12 = n11;
                        dArray6[n12] = dArray6[n12] + dArray2[n8][n7] * this.S[this.channeltoemission[n6][n5]][n7] * this.Q[n6][n7];
                    }
                    ++n11;
                }
            }
        }
    }
}

